const
  MaxLength         = 1024;     { our max data block size }
  FileNameLength    = 128;
  MaxTrys           = 20;       { error retry count }
  PadSize           = 20;       { packet padding to avoid buffer overun screw }
  AckChar           = 'U';      { for echo byte method }
type

FileNameString      = string[FileNameLength];

PacketType  = (Bad,TimedOut,FileEnq,FileAvail,NoCanDo,Done,
               Message,Quit,Startup,DataBlock,SendRQ,ChangeBaud,BufferOvr);

PacketHeaderType = record
                     CheckSum  : word;
                     Ptype     : byte;
                     Plength   : word;
                     PSequence : word;
                   end;
const
HeaderSize = SizeOf(PacketHeaderType);

type

PacketRecordType = record
                     CheckSum  : word;
                     Ptype     : byte;
                     Plength   : word;
                     PSequence : word;
                     Data : array [0..Maxlength -1] of byte;
                     Padding : array [1..PadSize] of byte;
                   end;

BufferType = array[0..sizeof(PacketRecordType) -1] of byte;

const
FileSpecSize = sizeof(FileNameString) + sizeof(longint);
FileSpecPadSize = MaxLength - FileSpecSize;

type

FileSpecRecordType   = record
                         FileName : FileNameString;
                         FileLength : longint;
                         Pad : array[1 .. FileSpecPadSize] of byte;
                       end;

PacketRecPtrType = ^PacketRecordType;
BufferPtrType = ^BufferType;


procedure PrintPacketType(ptype : PacketType);
begin
  case ptype of
    DataBlock:  write('DataBlock');
    SendRQ:     write('SendRQ');
    NoCanDo:    write('NoCanDo');
    Done:       write('Done');
    Bad:        write('Bad');
    TimedOut:   write('TimedOut');
    FileEnq:    write('FileEnq');
    FileAvail:  write('FileAvail');
    Message:    write('Message');
    Quit:       write('Quit');
    ChangeBaud: write('ChangeBaud');
  else          write('Unknown');
  end;
end;

function CalcCheckSum(rp : PacketRecPtrType) : word;
var
sum : word;
index : word;
begin
  sum := 0;
  { first checksum the type and length fields }
  sum := sum + rp^.PLength;
  sum := sum + rp^.PType;
  sum := sum + rp^.PSequence;
  { then checksum the data block }
  if rp^.PLength > 0 then
  begin
    for index := 0 to rp^.PLength -1 do
    begin
      sum := sum + rp^.Data[index];
    end;
  end;
  CalcCheckSum := sum + $DEAD;
  { ^^ this silly hack is done to avoid the 'all zero packet is ok' problem }
end;

