program Selectio;  { select console I/O FPXX }
{Still has a mysterious bug with write-writeln when launched from serial}
uses dos,crt;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

{$I WIDGET}
const
{ include out button picture }

{$I FPXXSBUT }

{ FPXX bottom row keypad keys }

KeyLcd = #$6B;
KeySerial = #$6C;
KeyBaud = #$6D;
KeyExit = #$6F;

var
FullScreen,TextRegion,ButRegion : RectRec;
TextWindow : TextWindowPtr;
SerialConsole : boolean;
BRIndex : byte;

procedure PrintCurrentBaudRate;
begin
  writeln(' Baud rate: ',ConsBaudRates[BRIndex],'      ');
end;

procedure BltButs;
begin
  GetDispRect(FullScreen);
  SplitRectY(FullScreen,TextRegion,ButRegion,RectYSize(FullScreen)-FPXXSButYDim);
  BLT(@FPXXSBut,FPXXSButXDim,FPXXSButYDim,0,ButRegion.UL.Y,RasterOp_NRep,BothPlanes);
  InsetEdge(TextRegion,TextRegion,bottom,-2);  {leave a little clearance}
end;

procedure KeyLoop;
var
done : boolean;
begin
  SerialConsole := false;
  BRindex := 11;  {=9600}
  done := false;
  TextWindow := TTYWinCreate(TextRegion,false,2);
  SleepCursor; {TTYWinCreate woke the cursor, put it back to sleep}
  gotoXY(1,1);
  write(chr(13),' Console = LCD + KB');
  gotoXY(1,3);
  PrintCurrentBaudRate;
  while not done do
  begin
    while readkey <> #0 do { wait for special char };
    case readkey of
      KeyExit :
      begin
        done := true;
      end;
      KeySerial :
      begin
        gotoXY(1,1);
        write(chr(13),' Console = Serial  ');
        SerialConsole := true;
      end;
      KeyLCD   :
      begin
        gotoXY(1,1);
        write(chr(13),' Console = LCD + KB');
        SerialConsole := false;
      end;
      KeyBaud  :
      begin
        if BRIndex < LastConsBaudRate then BRIndex := BRIndex +1 else BRIndex := 0;
        gotoXY(1,3);
        PrintCurrentBaudRate;
      end;
    end;
  end;
end;

procedure UseVideo;
begin
  writeln('Using Video out... aborting SelectIO');
  halt(2);
end;

begin          {main}
  DirectVideo := false;
  if GetVidDest = VIDDEST_VIDEO then UseVideo;
  InitGraphics;
  KeyPadOnly;
  BltButs;
  KeyLoop;
  { Notice that we don't leave with ExitGraphics as this would restore }
  { our old KB and video routing...                                    }
  if SerialConsole then
  begin
    SetTTYWin(FullScreen);
    ClearScreen;
    SerialOut;
    SerialInOnly;
    ConsBaudRateSelect(BRIndex);
  end
  else
  begin
    LCDOut;
    PCKBOnly;
    SetTTYWin(FullScreen);
    WakeCursor;
  end;
end.
