program SC;  { set contrast on FPXX with Samtron UG display}
uses dos,crt;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

{$I widget}
{$DEFINE USEFPWX}
{ include our pictures }
const
{$I AdjButs.pas}
{$I ContPic.pas}

{ XT KB cursor keys }
{$IFDEF USEGENERIC}
KeySave   = #$51;
KeyExit   = #$4F;
KeyOld    = #$47;
KeyUp     = #$48;
KeyDown   = #$50;
{$ENDIF}

{ FPWX,FPXX bottom row keypad keys }
{$IFDEF USEFPWX}
KeySave = #$6B;
KeyExit = #$6C;
KeyOld  = #$6D;
KeyUp   = #$6E;
KeyDown = #$6F;
{$ENDIF}

ContrastStep = $80;
MaxContrast = $9800;
MinContrast = $6000;

var
XDim : word;
YDim : word;
NPlanes : byte;
TextWin :RectRec;
FullScreen : RectRec;

OldContrast : word;
Contrast : word;

procedure BltButs;
begin
  GetDispSize(XDim,YDim,NPlanes);
  MakeRect(0,0,XDim-1,YDim-1,FullScreen);
  BLT(@ContPic,ContPicXDim,ContPicYDim,0,0,RasterOp_NRep,BothPlanes);
  BLT(@AdjButs,AdjButsXDim,AdjButsYDim,0,48,RasterOp_NRep,BothPlanes);
  MakeRect(0,0,ContPicXDim-1,ContPicYDim-1,TextWin);
end;

procedure KeyLoop;
var
done : boolean;
popup : boolean;
begin
  done := false;
  popup := false;
  while not done do
  begin
    while readkey <> #0 do { wait for special char };
    case readkey of
      KeySave :
      begin
        SaveSetup ;
        if not popup then DoubleBorderTTYWinPlace(TextWin,false);
        write(chr(13),'  Saved!','      ');
        popup := true;
      end;
      KeyExit :
      begin
        done := true;
      end;
      KeyOld :
      begin
        Contrast := OldContrast;
        SetContrast(Contrast);
        if not popup then DoubleBorderTTYWinPlace(TextWin,false);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
      KeyUp   :
      begin
        if Contrast < MaxContrast then Contrast := Contrast + ContrastStep;
        SetContrast(Contrast);
        if not popup then DoubleBorderTTYWinPlace(TextWin,false);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
      KeyDown :
      begin
        if Contrast > MinContrast then Contrast := Contrast - ContrastStep;
        SetContrast(Contrast);
        if not popup then DoubleBorderTTYWinPlace(TextWin,false);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
    end;
  end;
end;


begin          {main}
  DirectVideo := false;
  InitGraphics;
  BltButs;
  {IFNDEF USEGENERIC}
  KeyPadOnly;
  {ENDIF}
  OldContrast := GetContrast;
  Contrast := OldContrast;
  KeyLoop;
  ExitGraphics;
end.
