
type

PCXPaletteType = array[0..15] of array[0..2] of byte;

PCXHeaderType =
record
  Maker : byte;              { normally  $0A }
  Version : byte;            { 0,2,3,4,5 }
  Code : byte;               { 0 for uncompressed, 1 for rle compression }
  BitsPerPlane : byte;
  X1 : integer;
  Y1 : integer;
  X2 : integer;
  Y2 : integer;
  HRes : integer;
  VRes : integer;
  PCXPalette : PCXPaletteType;
  VidMode : byte;           { ?? unknown }
  NPlanes : byte;           { number of planes (4 max) }
  BytesPerLine : integer;   { must be even! }
  GreyScale : integer;      { 1 if color or b/w; 2 if grayscale }
  Unused  : array[71..128] of byte;
end;

PCXHeaderAsBytes = array[0..SizeOf(PCXHeaderType)-1] of byte;

const

  CountToken = $C0;
  CountMask  = $3F;
