

function PadWithSpaces(sstring: string;padlength : integer): string;
var
tstring : string;
index : integer;
tooshort : integer;

begin
  tstring := sstring;
  tooshort := padlength - length(sstring);
  if tooshort > 0 then
  begin
    for index := 1 to tooshort do tstring := tstring + ' ';
  end;
  PadWithSpaces := tstring;
end;


procedure StripLeadingBlanks(var st: string);
begin
  while (((st[1] =' ') or (st[1] = chr(9))) and (length(st) >0)) do delete(st,1,1);
end { StripLeadingBlanks };


procedure StripTrailingBlanks(var st: string);
begin
  while (copy(st,length(st),1)=' ') or (copy(st,length(st),1)=chr(9)) do delete(st,length(st),1);
end { StripTraiLingBlanks };

function ScanTillWhite(astr : string) : byte;
{ returns pos preceding first white space found, returns 0 for zero }
{ length string, or string length if no white space is found        }
begin
  asm
    cld
    lea si,astr
    segss lodsb
    xor ah,ah
    xchg ax,cx
    mov bl,0
    jcxz @done
  @searchloop:
    segss lodsb
    cmp al,$20
    jz @done
    cmp al,$09
    jz @done
    inc bl
    loop @searchloop
  @done:
    mov @result,bl
  end;
end;

function Strip(var rest: string): string;
var
first: string;
endst: integer;
begin
  StripLeadingBlanks(rest);
  endst := ScanTillWhite(rest);              { find position of first white space }
  first := copy(rest,1,endst);               { copy until white space or end }
  rest := copy(rest,endst+1,length(rest));   { delete stripped from rest }
  Strip := first;
end  { Strip };

function UpString(s:string) : string;
var
index : byte;
begin
  for index := 1 to length(s) do
  s[index] := upcase(s[index]);
  UpString := s;
end;

function StripNumber( var astring : string): integer;
var
index : integer;
returnvar : integer;
result : integer;
begin
  index := 1;
  while ((astring[index] >= '0') and (astring[index] <= '9'))  do
  begin
    index := index + 1;
  end;
  val(copy(astring,1,index-1),returnvar,result);
  astring := copy(astring,index,length(astring)-(index-1));
  StripNumber := returnvar
end { StripNumber };

function StripLetter( var astring : string): string;
var
index : integer;
result : integer;
begin
  index := 1;
  while ((astring[index] < '0') or (astring[index] > '9'))  do
  begin
    index := index + 1;
  end;
  StripLetter := copy(astring,1,index-1);
  astring := copy(astring,index,length(astring)-(index-1));
end { StripLetter };
