program ADDEMO;  {A-D meter demo }
uses dos;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

{ include our pascal interface shims }
{$I WIDGET }
{$I GENERAL }

procedure DoReading;
const
numchans = 4;
vref = 3.75;
meterscale = 1000;
var
scaledata : real;
meterrect,metergrouprect : RectRec;
meterbox : TitledBoxPtr;
mtitle : string;
bgs : array[1..numchans] of BarGraphPtr;
meter : byte;
foochar : word;
begin
  SelectGraphicFontByNumber(0);
  { Start with the full screen rectangle }
  GetDispRect(MeterGrouprect);
  meterbox := CreateTitledBox(metergrouprect,'A-D Readings',Top,CenterJustify);
  GetDataBox(meterbox,metergrouprect);
  { make meters }
  GetDataBox(meterbox,metergrouprect);
  InsetRect(metergrouprect,metergrouprect,-2,-2);
  InsetEdge(metergrouprect,metergrouprect,Bottom,-GState.GraphicFontInfo.CharHeight);
  { make room for scale on bottom edge of group }
  InsetEdge(metergrouprect,metergrouprect,Right,-GState.GraphicFontInfo.CharWidth*3);
  { make room for individual label text on Right }
  for meter := 1 to NumChans do
  begin
    DivideRectY(metergrouprect,meterrect,numchans,meter,meter);
    { divide the remaining space between the meters }
    InsetRect(meterrect,meterrect,0,-1);
    { leave vertical space between meters }
    bgs[meter] := HorBargraphCreate(meterrect,0,4*MeterScale,500,true);
    { Create bar graphs from meterrect, range 0 to 4000, tics every 500 }
    str(meter-1,mtitle);
    TitleRect(meterrect,Right,CenterJustify,mtitle);
  end;
  LabelBarGraph(bgs[NumChans], 0,'0');
  LabelBarGraph(bgs[NumChans], 2,'1');
  LabelBarGraph(bgs[NumChans], 4,'2');
  LabelBarGraph(bgs[NumChans], 6,'3');
  LabelBarGraph(bgs[NumChans], 8,'4');
  { label every other tic on last meter }
  HighlightTitledBox(MeterBox);
  while not keypressed do
  begin
    for meter := 1 to NumChans do
    begin
      scaledata := ReadAtoD(meter-1);
      scaledata := vref*scaledata/65535; {This gets us to volts}
      BarGraphUpdate(bgs[meter],trunc(scaledata * MeterScale + 0.5))
    end;
  end;
  foochar := ReadKey;
  TitledBoxDestroy(MeterBox);
end;

begin
  InitGraphics;
  KeyPadOnly;
  DoReading;
  ExitGraphics;
end.
