
const

BitOn = $FF;
BitOff = $00;

PPAddr    = $208;           { 82C55 port address}
DiskAddr  = $20C;           { Disk emulator address }
MiscBits   = $200;          { base of misc I/O bits }
FeedWD     = $203;          { Read here to warble the dog }
LCDON     = MiscBits + 0;   { Enables LCD circuitry }
BKLOn     = MiscBits + 1;   { turna ona de backlight }
Page      = MiscBits + 2;   { ROMBIOS page bit (A17) }
DALE      = MiscBits + 3;   { Disk chip ALE + EEPROM data in }
DCLE      = MiscBits + 4;   { Disk chip CLE + EEPROM shift clock }
DWP       = MiscBits + 5;   { Disk chip write protect }
DSKCE     = MiscBits + 6;   { Disk chip /CS }
EECS      = MiscBits + 7;   { EEPROM CS + A-D /CS }

SPDMask   = $01;            { SPDOUT EEPROM and A-D data out bit }
LCDMMask  = $02;            { LCD M signal (square wave at 1/2 frame rate) }

procedure WarbleDog;
var foobyte : byte;
begin
  foobyte := port[FeedWD];
end;

procedure Reboot;
begin
  port[Page] := BitOff;
  inline($EA/$00/$00/$FF/$FF);                 { JMP FFFF:0000 }
end;

function IsFPXX : boolean;
begin
  if GetCPUType = 'MESAFPXX' then IsFPXX := true else IsFPXX := false;
end;

