{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$N-}    {No numeric coprocessor}
{$S-}    {No stack checking}
{$D-}

program dispatch;

uses DOS;
{$I 8259}
{$I WIDGET}
const
NButs = 5;
CR    =$0D;

var

FullScreen,TextRegion,ButRegion,Abutton : RectRec;

procedure Usage;
begin
  writeln;
  writeln('DISPATCH Membrane switch reading kludge');
  writeln;
  writeln('USAGE: DISPATCH A B C D E ');
  writeln;
  writeln('OPTIONS A B C D E are strings returned by bottom 5 keys');
  halt(2);
end;

procedure DrawButs;
var but : byte;
begin
  SelectGraphicFontByNumber(0);
  GetDispRect(FullScreen);
  SplitRectY(FullScreen,TextRegion,ButRegion,(RectYSize(FullScreen)*4) div 5);
  for but := 1 to NButs do
  begin
    DivideRectX(ButRegion,Abutton,NButs,but,but);
    InsetRect(AButton,AButton,-2,0);
    OneLineLabeledButton(Abutton,ParamStr(but));
  end;
end;

procedure EchoParm(n : byte);
var
idx : byte;
ps : string;
fooword : word;
begin
  while QKeypressed do fooword:=QKeyRead;
  ps := ParamStr(n);
  for idx := 1 to length(ps) do
  begin
    if PushOnKBFIFO(byte(ps[idx])) then;
  end;
  if PushOnKBFIFO(CR) then;
end;

procedure KeyLoop;
var done : boolean;
begin
  done := false;
  while not done do
  begin
    done := true;
    case QKeyRead of
      $6B00 : EchoParm(1);
      $6C00 : EchoParm(2);
      $6D00 : EchoParm(3);
      $6E00 : EchoParm(4);
      $6F00 : EchoParm(5);
      else done := false;
    end;
  end;
end;

begin { main }
  if length(ParamStr(1)) = 0 then usage else
  InitGraphics;
  begin
    KeyPadOnly;
    DrawButs;
    KeyLoop;
  end;
  ExitGraphics;
end. { main };
