 		page	60,132
;************************************************************************
;*
;************************************************************************
		comment	`

"DSPDEMO2.ASM"

Demonstration program for the Mesa Electronics FPWX when used with a
  liquid crystal display.  Activates the liquid crystal display an makes
  it the TTY output destination.

Version 1.0, Wednesday December 8, 1993 - 21:47:44.

		`
;************************************************************************
;*
;*	Assembler: MASM 6.1a.
;*
;************************************************************************

		subttl	Revision history
		page
;************************************************************************
;*
;*	Revision history.
;*
;************************************************************************
		comment	`

1) Version 1.0a - Wednesday December 8, 1993 - 21:47:44.

   Code frozen for first version.

		`
;************************************************************************
;*
;************************************************************************

		subttl	Segment ordering
		page
;************************************************************************
;*
;*	Segment ordering.
;*
;************************************************************************
dispseg		segment	para public 'dispseg'
dispseg		ends

allend		segment para public 'allend'
allend		ends

xxcode		segment	word public 'xxcode'
xxcode		ends

stackseg	segment	word public 'stackseg'
stackseg	ends

		subttl	Includes
		page
;************************************************************************
;*
;*	Includes.
;*
;************************************************************************
		include	sint10.inc
		include	sint1a.inc

		subttl	Equates
		page
;************************************************************************
;*
;*	Equates.
;*
;************************************************************************
		.186				;(The V40 CPU can execute '186 instructions.)
;
;	Display type-specific constants for Samtron 128 x 64/40 nybbles
;	per line LCD panel.
;
PIXPERLINE128X64	equ	128		;Pixels per line.
NUMLINES128X64		equ	64		;Number of lines.
NYBBLESPLINE128X64	equ	40		;Bytes per display line.
CL1STRTCOL128X64	equ	(NYBBLESPLINE128X64-2)	;CL1 start nybble. (Relative to beginning of display line.)
CL1ENDCOL128X64		equ	(NYBBLESPLINE128X64-2)	;CL1 end nybble. (Relative to beginning of display line.)
FLMSTRTOFF128X64	equ	(NYBBLESPLINE128X64-2)	;FLM start offset. (Relative to beginning of display buffer.)
FLMENDOFF128X64		equ	(NYBBLESPLINE128X64-1)	;FLM end offset. (Relative to beginning of display buffer.)

NUMPLANES		equ	2		;Number of planes desired. (1 or 2.)
CONTRAST		equ	35327		;Value chosen for the Samtron display.
INVERTMODE		equ	0		;Non-zero for reverse video.

PIXPERLINE		equ	PIXPERLINE128X64
NUMLINES		equ	NUMLINES128X64
NYBBLESPLINE		equ	NYBBLESPLINE128X64
CL1STRTCOL		equ	CL1STRTCOL128X64
CL1ENDCOL		equ	CL1ENDCOL128X64
FLMSTRTOFF		equ	FLMSTRTOFF128X64
FLMENDOFF		equ	FLMENDOFF128X64

STACKLEVELS	equ	256

		subttl	Segments
		page
;************************************************************************
;*
;*	Segments.
;*
;************************************************************************
;
;	The display buffer segment.
;
dispseg		segment	para
		byte	((NUMPLANES*NYBBLESPLINE*NUMLINES)+32) dup (?)	;(A little bit more than enough.)
dispseg		ends

;
;	Stack segment.
;
stackseg	segment	word
		word	STACKLEVELS dup (?)
thestack	label	word
stackseg	ends

		subttl	Code
		page
;************************************************************************
;*
;*	Code.
;*
;************************************************************************
xxcode		segment	word public 'xxcode'
;
;	Function: video2lcd
;	Purpose: Switch video output to LCD display output.
;	Used by: Anyone.
;	Returns: Nothing.
;	Notes:
;	Revision history:
;	1) Wednesday December 8, 1993 - 21:47:44.
;
;	Register usage:
;	Entry:
;	No parameters passed.
;
;	Exit:
;	AX - Destroyed.
;	RF - Destroyed.
;
video2lcd	proc	pascal private uses bx cx
		local	rerouteinfo:sysvidreroute
		assume	ds:nothing,es:nothing,ss:nothing

		mov	rerouteinfo.commandHeader.commandCode,F_SYSVIDEOREROUTE
		mov	rerouteinfo.videoDest,VIDDEST_LCD	;Route to LCD handler.

		mov	ah,F_SPCLSYSCNTRL
		lea	bx,rerouteinfo
		mov	cx,ss
		int	01AH
;
;	(We're too cheap to bother to check for errors.)
;
		ret
video2lcd	endp

		ifdef	USECHECKSETUP
;
;	Function: checksetup
;	Purpose: Find out how much memory we're going to need for our
;	  display buffer.
;	Used by: Anyone.
;	Returns: The number of paragraphs needed.
;	Notes:
;	Revision history:
;	1) Wednesday December 8, 1993 - 21:47:44.
;
;	Register usage:
;	Entry:
;	No parameters passed.
;
;	Exit:
;	AX - The number of paragraphs needed for our display buffer.
;	RF - Destroyed.
;
checksetup	proc	pascal private uses bx cx
		local	setupcheckinfo:dispsetupchk
		assume	ds:nothing,es:nothing,ss:nothing

		mov	setupcheckinfo.commandHeader.commandCode,F_DISPCHECKSETUP
		mov	setupcheckinfo.nybblesPerLine,NYBBLESPLINE
		mov	setupcheckinfo.displayLines,NUMLINES
		mov	setupcheckinfo.numPlanes,NUMPLANES

		mov	ah,F_SPCLVIDCNTRL
		lea	bx,setupcheckinfo
		mov	cx,ss
		int	010H

		mov	ax,setupcheckinfo.paragraphsReq	;Paragraphs required for display buffer.
;
;	(We're too cheap to bother to check for errors.)
;
		ret
checksetup	endp
		endif

;
;	Function: initlcdvideo
;	Purpose: Initialize the LCD display system.
;	Used by: Anyone.
;	Returns: Nothing.
;	Notes:
;	  -Display contrast is initially set to 0.
;	Revision history:
;	1) Wednesday December 8, 1993 - 21:47:44.
;
;	Register usage:
;	Entry:
;	No parameters passed.
;
;	Exit:
;	AX - Destroyed.
;	RF - Destroyed.
;
initlcdvideo	proc	pascal private uses bx cx
		local	dispinitinfo:dispinit
		assume	ds:nothing,es:nothing,ss:nothing

		mov	dispinitinfo.commandHeader.commandCode,F_DISPINIT
		mov	dispinitinfo.displayDim.x,PIXPERLINE
		mov	dispinitinfo.displayDim.y,NUMLINES
		mov	dispinitinfo.nybblesPerLine,NYBBLESPLINE
		mov	dispinitinfo.cl1Start,CL1STRTCOL
		mov	dispinitinfo.cl1End,CL1ENDCOL
		mov	dispinitinfo.flmStartOffset,FLMSTRTOFF
		mov	dispinitinfo.flmEndOffset,FLMENDOFF
		mov	dispinitinfo.numPlanes,2
		mov	dispinitinfo.baseParagraph,dispseg	;Where the display image buffer will be built.
		mov	dispinitinfo.invertDisp,INVERTMODE

		mov	ah,F_SPCLVIDCNTRL
		lea	bx,dispinitinfo
		mov	cx,ss
		int	010H
;
;	(We're too cheap to bother to check for errors.)
;
		ret
initlcdvideo	endp

;
;	Function: setcontrast
;	Purpose: Set the display contrast.
;	Used by: Anyone.
;	Returns: Nothing.
;	Notes:
;	Revision history:
;	1) Wednesday December 8, 1993 - 21:47:44.
;
;	Register usage:
;	Entry:
;	No parameters passed.
;
;	Exit:
;	AX - Destroyed.
;	RF - Destroyed.
;
setcontrast	proc	pascal private uses bx cx
		local	cntrstinfo:contrastinfo
		assume	ds:nothing,es:nothing,ss:nothing

		mov	cntrstinfo.commandHeader.commandCode,F_DISPCONTRASTSET
		mov	cntrstinfo.displayContrast,CONTRAST

		mov	ah,F_SPCLVIDCNTRL
		lea	bx,cntrstinfo
		mov	cx,ss
		int	010H
;
;	(We're too cheap to bother to check for errors.)
;
		ret
setcontrast	endp

start:		mov	ax,stackseg
		mov	ss,ax
		mov	sp,offset thestack

		push	ds
;
;	1) Reroute video to LCD.
;
;	Video has to be rerouted first in order to make available the
;	added interrupt 010H LCD display support functions.
;
;	No video output should be attempted between the time video is
;	routed to LCD output (video2lcd()) and the time the LCD display
;	is initialized (initlcdvideo()).
;
		call	video2lcd

		ifdef	USECHECKSETUP
;
;	2) Find out how much memory we need for video buffers.
;
;	In an actual application, the number of paragraphs returned by
;	checksetup() in AX would be used to determine how large a video
;	buffer to allocate.
;
		call	checksetup
		endif
;
;	3) Initialize LCD video.
;
		call	initlcdvideo
;
;	4) Set display contrast.
;
		call	setcontrast
;
;	5) Go resident.
;
		mov	dx,seg allend
		pop	ax
		sub	dx,ax
		mov	ax,(031H shl 8) or 0	;Terminate but remain resident, success exit.
		int	021H			;Do it.

xxcode		ends

;************************************************************************
;*
;************************************************************************
		end	start
