{ TLC2543 serial A-D interface stuff }
{{$I DUMMYSPI.PAS }
{ dummy definitions to allow compile }


function Read2543(nextchan : byte) : word;
{ returns a 16 bit word instead of a byte for compatiblity with TLC1540 }
const
transferclocks = 12;   { using 12 bit mode }
select12 = 8;
lsbfirst = 2;
bipolar =  1;
var

bit : byte;
tdata : word;
amask : byte;
adata : byte;
dmask : word;
begin
  adata := (nextchan shl 4) and $F0;
  adata := adata or select12;
  SetDinLow;           { we set data to SP's low when doing random
                       { twiddles to avoid clobbering EEPROM }
  SetClockLow;
  SetCSLow;
  { send chan address and get returned data from previous cycle }
  amask := $80;
  dmask := $0800;
  tdata := $0000;
  for bit := 1 to TransferClocks do
  begin
    if DataHighQ then tdata := (tdata or dmask);       { read serial data }
    if (amask and adata) = 0 then SetDinLow else SetDinHigh;   { output new chan and mode }
    SetClockHigh;
    SetClockLow;
    amask := amask shr 1;
    dmask := dmask shr 1;
  end;
  SetCSHigh;
  { at this point CS is high but Din is low, so we can't hurt EEPROM }
  { The the actual conversion happens when CS is high }
  Read2543 := tdata;
end;


