program ReadAD;      { read 8,10, or 12 bits from TLCXXXX type A-D }
uses CRT;

{$I GENERAL.PAS }      { cpu type }
{$I FPTXLOW.PAS }      { port and bit locations }
{$I FPTXSPI.PAS }      { low level serial peripheral (EEPROM and A-D) bit I/O }
{$I TLC2543.PAS }       {12 BIT A-D read routine }
{$I TLC1540.PAS }       {10 BIT A-D read routine }
{$I TLC540.PAS }        { 8 BIT A-D read routine }

const
VRef = 3.75;


var
Foo : word;
Scale : real;

procedure bumout(s : string );
begin
writeln(s);
halt(2);
end;

procedure ADSetup;
var adata : word;
begin
  scale := 4095.0;
  adata := Read2543(0);  { dummy read to get address started }
  adata := Read2543(0);  { select a channel }
  adata := Read2543(14); { set power down mode to avoid high power startup mode }
end;

procedure ReadLoop;
var
chan : byte;
nextchan : byte;
adata : word;
sx,sy : byte;
begin
  for chan := 0 to 11 do
  begin
    nextchan := (chan +1) mod 12;
    adata := Read2543(NextChan);  { read data + start next conversion }
    sy := (chan div 2) +1;
    if (chan and 1) = 0 then sx := 1 else sx := 13;
    GoToXY(sx,sy);
    case chan of
      8: write('V =  ',(adata*VRef*2)/scale:2:2);
      9: write('T =  ',(0.628-(adata*VRef/scale))/0.0022:2:2);
      10: write('G =  ',adata:4);
      11: write('CK = ',adata:4);
      else write('Ch',chan:2,'=',adata:4);
    end;
  end;
end;

procedure Usage;
begin
  writeln;
  writeln('USAGE: READAD');
  writeln;
  halt(2);
end;

function CheckCpu : boolean;
begin
  CheckCpu := (GetCpuType = 'MESAFPTX');
end;


begin {main}
  if not CheckCPU then bumout('This is not an FPTX');
  DirectVideo := false;
  ClrScr;
  ADSetup;
  while not keypressed do
  begin
    readloop;
  end;
  Foo := readkey;
end.
