{---------------------------------------------------------------------------}
{
   "PCPUSRVC.H"

   Include file containing constants and structures for use with Mesa
	 Electronics FPTX CPU card public service functions.

   Version 1.1, Monday July 7, 1997 -- 16:20:02.

   Copyright (c) 1996 - 1997 by Mesa Electronics.
}
{---------------------------------------------------------------------------}
{
   Revision history.

   1) Version 1.0, Tuesday December 17, 1996 -- 17:52:33.

      Code frozen for version 1.0.


   2) Version 1.1, Monday July 7, 1997 -- 16:20:02.

      Changes from version 1.0:
	  1) Enumeration added: membraneeventid.

	  2) Function F_PUBSRVCXABLEMEMBKB added to publicservicefuncs.

	  3) Structures added: pubmembranekbinfo, pubmembranekbxable.
}
{---------------------------------------------------------------------------}

const

M_MEMBBEEPONREQ : word = (1 shl 1); { Membrane keyclick control mask. }

{---------------------------------------------------------------------------}

{ Enumerations.
}

{ Function numbers that are used to access the ROMBIOS's public service
	 functions.
}


{	{ The following are code revision level 0 functions.
	}
	F_PUBSRVCINFOQ = 0;       { Get code revision level; etc. }
	F_PUBSRVCXABLEKB =1 ;         { Xable PC keyboard input. }
	F_PUBSRVCUSERINFOLENQ =2;    { Get number of bytes of user information. }
	F_PUBSRVCUSERINFOQ =3;       { Get user information. }
	F_PUBSRVCNUMCONFIGWORDSQ = 4; { Inquire number of user configuration words available. }
	F_PUBSRVCCONFIGWORDREAD = 5;  { Read configuration word. }
	F_PUBSRVCCONFIGWORDWRITE = 6; { Write configuration word. }
	F_PUBSRVCCPUREVQ = 7;         { Get CPU card revision number. }
	F_PUBSRVCMEMBSCANINFO = 8;    { Set membrane keyboard event handler particulars. }
	F_PUBSRVCMEMBSCANINFOQ = 9;   { Get current membrane keyboard event handler particulars. }
	F_PUBSRVCATODTYPE = 10;        { Get local A-to-D converter type. }
	F_PUBSRVCATODRAWREAD = 11;     { Raw read of A-to-D converter channel. }
	F_PUBSRVCMEMBKBXABLE = 12;     { Xable membrane keyboard input. }
	F_PUBSRVCMEMBKBXABLEQ = 13 ;    { Inquire membrane keyboard input xable state. }

	NUMPUBSRVCFUNCS = 14;


{ Basic error codes for public service functions.
}

	E_PUBSRVCERRNONE = 0; { No error. }
	E_PUBSRVCERRBADFUNC = 1;  { Invalid function number. }
	E_PUBSRVCERRBASE = 2;     { Base error code number. }


{ Constants used for specifying membrane keyboard events.
}
	KSTATE_NONE = 0; { No event. }
	KSTATE_MAKE = 1;     { Key make event. }
	KSTATE_BREAK = 2;    { Key break event. }
	KSTATE_REPEAT = 3;   { Key repeat event. }

	NUMKSTATES = 4;

{---------------------------------------------------------------------------}

{ Structures.
}
{ Structure used to pass a command to, and receive completion status from, a
     ROMBIOS's public functions.  This structure is always the first element
     of any public function command structure.

   When the special functions entry point is called, CX:BX must be loaded
     with a far pointer to one of the following structures that begins with a
     pfuncshdr structure.  (CX contains the segment, BX contains the offset.)
}
type

pfuncshdr =
record
  commandCode : word ; { The command code from the list of syscntrlfuncs. }
  errorCode : word;   { The result code from the list of syscntrlerrs. }
end; { pfuncshdr }

{ Structure used to inquire whether the public functions code is available.
     (pubfuncsavailq.commandHeader.commandCode == F_PUBSRVCINFOQ.)
}

pubfuncsavailq =
record
  commandHeader : pfuncshdr ; { Command/status information. }
  toggleByte : byte;     { Gets inverted if there's code to answer. }
  revisionLevel : word ; { Code revision level. }
end; {pubfuncsavailq}


{ Structure used to xable PC keyboard input.
     (pubxablekb.commandHeader.commandCode == F_PUBSRVCXABLEKB.)
}
pubxablekb =
record
  commandHeader : pfuncshdr ; { Command/status information. }
  getSettings : byte ; { Non-zero to get state, zero to set. }
  enableKB : byte;    { Xable flag. Setting state returns previous state. }
end { pubxablekb} ;


{ Structure used to read user information length.
     (pubuserinfolenq.commandHeader.commandCode == F_PUBSRVCUSERINFOLENQ.)
}
pubuserinfolenq =
record
  commandHeader : pfuncshdr  ; { Command/status information. }
  userInfoLen : word ; { Bytes of storage required for user information. }
end; { pubuserinfolenq }

{ Structure used to read user information.
     (pubuserinfoq.commandHeader.commandCode == F_PUBSRVCUSERINFOQ.)
}
pubuserinfoq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  bytesToRead : word;     { Number of bytes of user information to read. -1 for all bytes. }
  userInfoPtr : pointer ; { Pointer to user information destination. }
end;{ pubuserinfoq}

{ Structure used to inquire the number of system configuration words
	 available for customer use.
     (pubconfigwordsq.commandHeader.commandCode == F_PUBSRVCNUMCONFIGWORDSQ.)
}
pubconfigwordsq =
record
  commandHeader : pfuncshdr; { Command/status information. }
  numWords : word ; { Number of available configuration words. }
end; {pubconfigwordsq}

{ Structure used to read or write system configuration words.
     (pubconfigword.commandHeader.commandCode == F_PUBSRVCCONFIGWORDREAD or
     F_PUBSRVCCONFIGWORDWRITE.)

   User configuration words are uncommitted non-volatile storage that may be
     used for customer-specific applications.  Valid configuration word
     indices are 0 to (pubconfigwordsq.numWords - 1), inclusive.  The
     specified configuration word is written to non-volatile storage upon
     invocation of F_PUBSRVCCONFIGWORDWRITE, rather than when the system
     configuration is saved, so the customer's software must manage wear on
     those systems that use EEPROM for non-volatile storage.
}
const
	E_PUBCONFIGWORDINDEX = E_PUBSRVCERRBASE;   { Invalid configuration word index. }
	E_PUBCONFIGWORDSHARE = E_PUBSRVCERRBASE+1; { Shared resource unavailable. Try again. }
	E_PUBCONFIGWORDWRITE = E_PUBSRVCERRBASE+2; { Write verification failure. }

	NUMPUBCONFIGWORDERRS = E_PUBSRVCERRBASE+3;
type

pubconfigword =
record
  commandHeader : pfuncshdr ; { Command/status information. }
  wordIndex : word; { The index of the word to be written. }
  theWord : word ;   { The word. }
end; {pubconfigword}

{ Structure used to inquire about the CPU card's hardware revision level.
     (pubcpurevinfo.commandHeader.commandCode == F_PUBSRVCCPUREVQ.)
}
pubcpurevinfo =
record
  commandHeader : pfuncshdr; { Command/status information. }
  cpuRevNum : byte ; { 0 for rev. A, 1 for rev. B, etc. }
end; {pubcpurevinfo}

{ Structure used to read the local digital-to-analog converter type.
     (puba2dtypeinfo.commandHeader.commandCode == F_PUBSRVCATODTYPE.)
}
puba2dtypeinfo =
record
  commandHeader : pfuncshdr; { Command/status information. }
  a2dTypeStringPtr : pointer ; { Pointer to upper case '\0'-terminated string containing converter part number. }
  numChannels : byte ;  { Number of accessible channels. }
end; {puba2dtypeinfo}

{ Structure used to read an A-to-D converter channel.
     (puba2dread.commandHeader.commandCode == F_PUBSRVCATODRAWREAD.

   Note that setting .isTimeCritical to non-zero will cause the function to
     return with E_PUBA2DREADTIMEOUT immediately if the A-to-D converter is
	 busy.  If .isTimeCritical is set to zero, the function will wait until
	 it has access to the converter before returning.

  All return values are scaled to the range 0...65535 -- for a 10-bit
    converter, bits 0...5 contain zero; for a 12 bit converter, bits 0...3
	contain zero, and for a 16-bit converter all bits are significant.}
const


	E_PUBA2DREADTIMEOUT = E_PUBSRVCERRBASE; { The converter is busy. }
	E_PUBA2DREADCHANNEL = E_PUBSRVCERRBASE +1; { Invalid converter channel number. }

	NUMPUBA2DREADERRS = E_PUBSRVCERRBASE +2;

type
puba2dread =
record
  commandHeader : pfuncshdr; { Command/status information. }
  isTimeCritical : byte ; { Non-zero will give up immediately if the A-to-D converter is busy. }
  channelNumber : byte ;  { Number of the converter channel to be read. }
  a2dData : word ;       { Returned conversion value. }
end; {puba2dread}


{ Structure used to read/write membrane keyboard control information.
     (pubmembranekbinfo.commandHeader.commandCode == F_PUBSRVCMEMBSCANINFO or
	 F_PUBSRVCMEMBSCANINFOQ.)

   Note that all time-related values are measured in membrane keyboard scans.
}
pubmembranekbinfo =
record
  commandHeader : pfuncshdr; { Command/status information. }
  clickScans : word ;       { Duration of system-generated key click beeps. }
  clickDivisor : word ;     { Key click beep divisor for system-generated clicks. }
  clickEnable : byte;       { Enable generation of key clicks by default (ROMBIOS-resident) scan event handler. }
  ovfBeepScans : word;     { Duration of keyboard FIFO overflow beeps generated by default scan event handler. }
  ovfBeepDivisor : word;   { Keyboard FIFO overflow beep divisor for default scan event handler. }
  ovfBeepEnable : byte;     { Enable generation of overflow beep by default scan event handler. }
  debounceScans : word ;    { Debounce time. }
  repeatRateScans : word;  { Repeat event generation rate. }
  repeatDelayScans : word; { Initial repeat event generation delay. 0 disables repeat. }
  keyHoldScans : byte;      { Key up recognition delay time. (Noise filter.) }
  codeEntryPoint : pointer;        { Address of membrane event handler. }
  numKeys : word;          { Number of keys in scan matrix. This field is read-only. }
end; { pubmembranekbinfo }

{ Structure used to xable the membrane keyboard and read its xable state.
     (pubmembranekbxable.commandHeader.commandCode == F_PUBSRVCMEMBKBXABLE or
	 F_PUBSRVCMEMBKBXABLEQ.)
}
pubmembranekbxable =
record
  commandHeader : pfuncshdr; { Command/status information. }
  scanEnable : byte ; { Non-zero to enable scanning, zero to disable. }
end; { pubmembranekbxable}

{---------------------------------------------------------------------------}
