
option expr32
option casemap:none

IFNDEF	pcpusrvc_inc
pcpusrvc_inc	EQU		1

; Begin of file ..\include\pcpusrvc.h
; ---------------------------------------------------------------------------
; 
;    "PCPUSRVC.H"
; 
;    Include file containing constants and structures for use with Mesa
; 	 Electronics FPTX CPU card public service functions.
; 
;    Version 1.1, Wednesday December 10, 1997 -- 10:35:36.
; 
;    Copyright (c) 1997 by Mesa Electronics.
; 
; ---------------------------------------------------------------------------
; 
;    Revision history.
; 
;    1) Version 1.0, Saturday September 20, 1997 -- 11:46:34.
; 
;       Code frozen for version 1.0.
; 
; 
;    2) Version 1.1, Wednesday December 10, 1997 -- 10:35:36.
; 
;       Changes from version 1.0:
; 	  1) Level 1 function numbers added to publicservicefuncs:
; 	     F_PUBSRVCDISPCONTRAST, F_PUBSRVCDISPCONTRASTQ,
; 		 F_PUBSRVCBACKLITEBRITENESS, F_PUBSRVCBACKLITEBRITENESSQ,
; 		 F_PUBSRVCDISPTIMEOUT, F_PUBSRVCDISPTIMEOUTQ.
; 
; 	  2) Structures added: pubbacklightbriteness, pubdispcontrast,
; 	     pubdisptimeout.
; 
; ---------------------------------------------------------------------------
H_PCPUSRVC		TEXTEQU		<>
; ---------------------------------------------------------------------------
;  #defines.
; 
;  Membrane keyboard handler control masks returned by
;      *(pubmembranekbinfo.codeEntryPoint).
; 
;  Membrane key backlight turn-on request. 
B_MEMBBAKLITEONREQ		EQU		0t
M_MEMBBAKLITEONREQ		EQU		000000001h
;  Membrane keyclick request mask. 
B_MEMBBEEPONREQ		EQU		1t
M_MEMBBEEPONREQ		EQU		000000002h
; ---------------------------------------------------------------------------
;  Enumerations.
; 
;  Function numbers that are used to access the ROMBIOS's public service
; 	 functions.
; 
;  The following are code revision level 0 functions.
; 	
F_PUBSRVCINFOQ		EQU		0t
;  Get code revision level, etc. 
F_PUBSRVCXABLEKB		EQU		1t
;  Xable PC keyboard input. 
F_PUBSRVCUSERINFOLENQ		EQU		2t
;  Get number of bytes of user information. 
F_PUBSRVCUSERINFOQ		EQU		3t
;  Get user information. 
F_PUBSRVCNUMCONFIGWORDSQ		EQU		4t
;  Inquire number of user configuration words available. 
F_PUBSRVCCONFIGWORDREAD		EQU		5t
;  Read configuration word. 
F_PUBSRVCCONFIGWORDWRITE		EQU		6t
;  Write configuration word. 
F_PUBSRVCCPUREVQ		EQU		7t
;  Get CPU card revision number. 
F_PUBSRVCMEMBSCANINFO		EQU		8t
;  Set membrane keyboard event handler particulars. 
F_PUBSRVCMEMBSCANINFOQ		EQU		9t
;  Get current membrane keyboard event handler particulars. 
F_PUBSRVCATODTYPE		EQU		10t
;  Get local A-to-D converter type. 
F_PUBSRVCATODRAWREAD		EQU		11t
;  Raw read of A-to-D converter channel. 
F_PUBSRVCMEMBKBXABLE		EQU		12t
;  Xable membrane keyboard input. 
F_PUBSRVCMEMBKBXABLEQ		EQU		13t
;  Inquire membrane keyboard input xable state. 
;  The following are code revision level 1 functions.
; 	
F_PUBSRVCDISPCONTRAST		EQU		14t
;  Set display contrast. (No-op on FPTX.) 
F_PUBSRVCDISPCONTRASTQ		EQU		15t
;  Get current display contrast. (Returns dummy value.) 
F_PUBSRVCBACKLITEBRITENESS		EQU		16t
;  Set display backlight brightness. 
F_PUBSRVCBACKLITEBRITENESSQ		EQU		17t
;  Get display backlight brightness. 
F_PUBSRVCDISPTIMEOUT		EQU		18t
;  Set display shut-off timeout. 
F_PUBSRVCDISPTIMEOUTQ		EQU		19t
;  Get display shut-off timeout. 
NUMPUBSRVCFUNCS		EQU		20t

publicservicefuncs		TYPEDEF		SWORD

;  Basic error codes for public service functions.
; 
E_PUBSRVCERRNONE		EQU		0t
;  No error. 
E_PUBSRVCERRBADFUNC		EQU		1t
;  Invalid function number. 
E_PUBSRVCERRBASE		EQU		2t
;  Base error code number. 

publicserviceerrs		TYPEDEF		SWORD

;  Constants used for specifying membrane keyboard events.
; 
KSTATE_NONE		EQU		0t
;  No event. 
KSTATE_MAKE		EQU		1t
;  Key make event. 
KSTATE_BREAK		EQU		2t
;  Key break event. 
KSTATE_REPEAT		EQU		3t
;  Key repeat event. 
NUMKSTATES		EQU		4t

membraneeventid		TYPEDEF		SWORD

; ---------------------------------------------------------------------------
;  Structures.
; 
;  Structure used to pass a command to, and receive completion status from, a
;      ROMBIOS's public functions.  This structure is always the first element
;      of any public function command structure.
; 
;    When the special functions entry point is called, CX:BX must be loaded
;      with a far pointer to one of the following structures that begins with a
;      pfuncshdr structure.  (CX contains the segment, BX contains the offset.)
; 
;  The command code from the list of syscntrlfuncs. 
;  The result code from the list of syscntrlerrs. 
pfuncshdr		STRUCT 1t
commandCode		WORD		?
errorCode		WORD		?
pfuncshdr		ENDS

;  Structure used to inquire whether the public functions code is available.
;      (pubfuncsavailq.commandHeader.commandCode == F_PUBSRVCINFOQ.)
; 
;  Command/status information. 
;  Gets inverted if there's code to answer. 
;  Code revision level. 
pubfuncsavailq		STRUCT 1t
commandHeader		pfuncshdr		<>
toggleByte		BYTE		?
revisionLevel		WORD		?
pubfuncsavailq		ENDS

;  Structure used to xable PC keyboard input.
;      (pubxablekb.commandHeader.commandCode == F_PUBSRVCXABLEKB.)
; 
;  Command/status information. 
;  Non-zero to get state, zero to set. 
;  Xable flag. Setting state returns previous state. 
pubxablekb		STRUCT 1t
commandHeader		pfuncshdr		<>
getSettings		BYTE		?
enableKB		BYTE		?
pubxablekb		ENDS

;  Structure used to read user information length.
;      (pubuserinfolenq.commandHeader.commandCode == F_PUBSRVCUSERINFOLENQ.)
; 
;  Command/status information. 
;  Bytes of storage required for user information. 
pubuserinfolenq		STRUCT 1t
commandHeader		pfuncshdr		<>
userInfoLen		WORD		?
pubuserinfolenq		ENDS

;  Structure used to read user information.
;      (pubuserinfoq.commandHeader.commandCode == F_PUBSRVCUSERINFOQ.)
; 
;  Command/status information. 
;  Number of bytes of user information to read. -1 for all bytes. 
@t_pcpusrvc0		TYPEDEF		FAR PTR BYTE
;  Pointer to user information destination. 
pubuserinfoq		STRUCT 1t
commandHeader		pfuncshdr		<>
bytesToRead		WORD		?
userInfoPtr		@t_pcpusrvc0		?
pubuserinfoq		ENDS

;  Structure used to inquire the number of system configuration words
; 	 available for customer use.
;      (pubconfigwordsq.commandHeader.commandCode == F_PUBSRVCNUMCONFIGWORDSQ.)
; 
;  Command/status information. 
;  Number of available configuration words. 
pubconfigwordsq		STRUCT 1t
commandHeader		pfuncshdr		<>
numWords		WORD		?
pubconfigwordsq		ENDS

;  Structure used to read or write system configuration words.
;      (pubconfigword.commandHeader.commandCode == F_PUBSRVCCONFIGWORDREAD or
;      F_PUBSRVCCONFIGWORDWRITE.)
; 
;    User configuration words are uncommitted non-volatile storage that may be
;      used for customer-specific applications.  Valid configuration word
;      indices are 0 to (pubconfigwordsq.numWords - 1), inclusive.  The
;      specified configuration word is written to non-volatile storage upon
;      invocation of F_PUBSRVCCONFIGWORDWRITE, rather than when the system
;      configuration is saved, so the customer's software must manage wear on
;      those systems that use EEPROM for non-volatile storage.
; 
E_PUBCONFIGWORDINDEX		EQU		2t
;  Invalid configuration word index. 
E_PUBCONFIGWORDSHARE		EQU		3t
;  Shared resource unavailable. Try again. 
E_PUBCONFIGWORDWRITE		EQU		4t
;  Write verification failure. 
NUMPUBCONFIGWORDERRS		EQU		5t

pubconfigworderrs		TYPEDEF		SWORD

;  Command/status information. 
;  The index of the word to be written. 
;  The word. 
pubconfigword		STRUCT 1t
commandHeader		pfuncshdr		<>
wordIndex		WORD		?
theWord		WORD		?
pubconfigword		ENDS

;  Structure used to inquire about the CPU card's hardware revision level.
;      (pubcpurevinfo.commandHeader.commandCode == F_PUBSRVCCPUREVQ.)
; 
;  Command/status information. 
;  0 for rev. A, 1 for rev. B, etc. 
pubcpurevinfo		STRUCT 1t
commandHeader		pfuncshdr		<>
cpuRevNum		BYTE		?
pubcpurevinfo		ENDS

;  Structure used to read the local digital-to-analog converter type.
;      (puba2dtypeinfo.commandHeader.commandCode == F_PUBSRVCATODTYPE.)
; 
;  Command/status information. 
@t_pcpusrvc1		TYPEDEF		FAR PTR SBYTE
;  Pointer to upper case '0'-terminated string containing converter part number. 
;  Number of accessible channels. 
puba2dtypeinfo		STRUCT 1t
commandHeader		pfuncshdr		<>
a2dTypeStringPtr		@t_pcpusrvc1		?
numChannels		BYTE		?
puba2dtypeinfo		ENDS

;  Structure used to read an A-to-D converter channel.
;      (puba2dread.commandHeader.commandCode == F_PUBSRVCATODRAWREAD.
; 
;    Note that setting .isTimeCritical to non-zero will cause the function to
;      return with E_PUBA2DREADTIMEOUT immediately if the A-to-D converter is
; 	 busy.  If .isTimeCritical is set to zero, the function will wait until
; 	 it has access to the converter before returning.
; 
;   All return values are scaled to the range 0...65535 -- for a 10-bit
;     converter, bits 0...5 contain zero; for a 12 bit converter, bits 0...3
; 	contain zero, and for a 16-bit converter all bits are significant.
; 
E_PUBA2DREADTIMEOUT		EQU		2t
;  The converter is busy. 
E_PUBA2DREADCHANNEL		EQU		3t
;  Invalid converter channel number. 
NUMPUBA2DREADERRS		EQU		4t

puba2dreaderrs		TYPEDEF		SWORD

;  Command/status information. 
;  Non-zero will give up immediately if the A-to-D converter is busy. 
;  Number of the converter channel to be read. 
;  Returned conversion value. 
puba2dread		STRUCT 1t
commandHeader		pfuncshdr		<>
isTimeCritical		BYTE		?
channelNumber		BYTE		?
a2dData		WORD		?
puba2dread		ENDS

;  Structure used to read/write membrane keyboard control information.
;      (pubmembranekbinfo.commandHeader.commandCode == F_PUBSRVCMEMBSCANINFO or
; 	 F_PUBSRVCMEMBSCANINFOQ.)
; 
;    Note that all time-related values are measured in membrane keyboard scans.
; 
;  Command/status information. 
;  Duration of system-generated key click beeps. 
;  Key click beep divisor for system-generated clicks. 
;  Enable generation of key clicks by default (ROMBIOS-resident) scan event handler. 
;  Duration of keyboard FIFO overflow beeps generated by default scan event handler. 
;  Keyboard FIFO overflow beep divisor for default scan event handler. 
;  Enable generation of overflow beep by default scan event handler. 
;  Debounce time. 
;  Repeat event generation rate. 
;  Initial repeat event generation delay. 0 disables repeat. 
;  Key up recognition delay time. (Noise filter.) 
@t_pcpusrvc2		TYPEDEF		FAR PTR 
;  Address of membrane event handler. 
;  Number of keys in scan matrix. This field is read-only. 
pubmembranekbinfo		STRUCT 1t
commandHeader		pfuncshdr		<>
clickScans		WORD		?
clickDivisor		WORD		?
clickEnable		BYTE		?
ovfBeepScans		WORD		?
ovfBeepDivisor		WORD		?
ovfBeepEnable		BYTE		?
debounceScans		WORD		?
repeatRateScans		WORD		?
repeatDelayScans		WORD		?
keyHoldScans		BYTE		?
codeEntryPoint		@t_pcpusrvc2		?
numKeys		WORD		?
pubmembranekbinfo		ENDS

;  Structure used to xable the membrane keyboard and read its xable state.
;      (pubmembranekbxable.commandHeader.commandCode == F_PUBSRVCMEMBKBXABLE or
; 	 F_PUBSRVCMEMBKBXABLEQ.)
; 
;  Command/status information. 
;  Non-zero to enable scanning, zero to disable. 
pubmembranekbxable		STRUCT 1t
commandHeader		pfuncshdr		<>
scanEnable		BYTE		?
pubmembranekbxable		ENDS

;  Structure used to read/write display contrast.
;      (pubmembranekbinfo.commandHeader.commandCode == F_PUBSRVCDISPCONTRAST or
; 	 F_PUBSRVCDISPCONTRASTQ.)
; 
;    F_PUBSRVCDISPCONTRAST is a no-op on the FPTX, while F_PUBSRVCDISPCONTRASTQ
;      returns a dummy value.
; 
;  Command/status information. 
;  The display contrast value has a full scale value of 65535 and a minimum
; 	     value of 0.  A contrast setting of 32767 therefore gives a setting of
; 	     about 50 percent full scale.
; 	
pubdispcontrast		STRUCT 1t
commandHeader		pfuncshdr		<>
displayContrastPercent		WORD		?
pubdispcontrast		ENDS

;  Structure used to read/write display backlight brightness.
; 	 (pubmembranekbinfo.commandHeader.commandCode ==
; 	 F_PUBSRVCBACKLITEBRITENESS or F_PUBSRVCBACKLITEBRITENESSQ.)
; 
;  Command/status information. 
;  The display backlight brightness value has a full scale value of 65535 and
; 	     a minimum value of 0.  A contrast setting of 32767 therefore gives a
; 		 setting of about 50 percent full scale.
; 	
pubbacklightbriteness		STRUCT 1t
commandHeader		pfuncshdr		<>
backlightLevelPercent		WORD		?
pubbacklightbriteness		ENDS

;  Structure used to read/write display shut-off timeout.
; 	 (pubmembranekbinfo.commandHeader.commandCode == F_PUBSRVCDISPTIMEOUT or
; 	 F_PUBSRVCDISPTIMEOUTQ.)
; 
;  Command/status information. 
;  Note that the minimum shut-off timeout period is about one minute; values
; 	     less than this will be silently adjusted.  Upon return, .timeOut
; 		 contains the actual display timeout value that will be used.
; 	
;  Backlight shutoff timeout in 18.2 Hz system ticks. 
pubdisptimeout		STRUCT 1t
commandHeader		pfuncshdr		<>
timeOut		WORD		?
pubdisptimeout		ENDS

; ---------------------------------------------------------------------------
; End of file ..\include\pcpusrvc.h

ENDIF

