/*---------------------------------------------------------------------------*/
/*
   "BKLTDEMO.C"

   Mesa Electronics FPTX backlight control demo.

   Version 1.0, Wednesday December 10, 1997 -- 12:50:47.
*/
/*---------------------------------------------------------------------------*/
/*
   Compiler: Borland C++, version 3.1.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Wednesday December 10, 1997 -- 12:50:47.

      Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <limits.h>
#include <dos.h>
#include "biosid.h"
#include "pcpusrvc.h"

/*---------------------------------------------------------------------------*/

/* Function: pubservicecall
   Purpose: Call our public services code.
   Used by: Anyone.
   Returns: Pass/fail status.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static signed pubservicecall(void far *parmptr)

{
	static unsigned char far *servicevec = MK_FP(ROMBIOSIDSEG, (ROMBIOSIDOFF + offsetof(rombiosid, jmp2PublicServices))) ;


	asm {
				mov		bx,word ptr parmptr[0]	// Offset of far pointer.
				mov		cx,word ptr parmptr[2]	// Segment of far pointer.
				call	dword ptr [servicevec]	// Call the CPU public services code.
				cld								// (Just in case.)
	}
	return (((((pfuncshdr far *)parmptr) -> errorCode) != E_PUBSRVCERRNONE) ? -1 : 0) ;
}

/*---------------------------------------------------------------------------*/

/* Function: checkcpu
   Purpose: Determine whether we're running on the required CPU card.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static void checkcpu(void)

{
	static const char *idmsg = BIOSIDMSG ;

	unsigned i ;

	rombiosid const far *idptr = MK_FP(ROMBIOSIDSEG, ROMBIOSIDOFF) ;


	for(i = 0 ; ; i++)
	{
		if(idmsg[i] == '\0')
		{
			break ;
		}
		if(idmsg[i] != (idptr -> sysMsg[i]))
		{
			fprintf(stderr, "\n\aIncorrect CPU card.\n") ;

			exit(1) ;
		}
	}
}

/*---------------------------------------------------------------------------*/

/* Function: publicapicheck
   Purpose: Make sure that the system ROMBIOS supports public API functions.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static void publicapicheck(void)

{
	pubfuncsavailq funcsinfo ;


	(funcsinfo . toggleByte) = 0x55 ;
	(funcsinfo . commandHeader . commandCode) = F_PUBSRVCINFOQ ;
	if(pubservicecall(&funcsinfo) < 0)
	{
		fprintf(stderr, "\n\aPublic services code not supported.\n") ;

		exit(1) ;
	}
	if((funcsinfo . toggleByte) != 0xAA)
	{
		fprintf(stderr, "\n\aPublic services code doesn't respond.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: getintensity
   Purpose: Read the current display backlight intensity setting.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static unsigned short getintensity(void)

{
	pubbacklightbriteness britenessinfo ;


	(britenessinfo . commandHeader . commandCode) = F_PUBSRVCBACKLITEBRITENESSQ ;
	if(pubservicecall(&britenessinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't read display backlight brightness.\n") ;

		exit(1) ;
	}
	else
	{
		return (britenessinfo . backlightLevelPercent) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: settensity
   Purpose: Set the display backlight intensity.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static void settensity(unsigned short tensity)

{
	pubbacklightbriteness britenessinfo ;


	(britenessinfo . commandHeader . commandCode) = F_PUBSRVCBACKLITEBRITENESS ;
	(britenessinfo . backlightLevelPercent) = tensity ;
	if(pubservicecall(&britenessinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't set display backlight brightness.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: gettimeout
   Purpose: Read the current display timeout.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static unsigned short gettimeout(void)

{
	pubdisptimeout timeoutinfo ;


	(timeoutinfo . commandHeader . commandCode) = F_PUBSRVCDISPTIMEOUTQ ;
	if(pubservicecall(&timeoutinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't read display timeout.\n") ;

		exit(1) ;
	}
	else
	{
		return (timeoutinfo . timeOut) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: settimeout
   Purpose: Set the display timeout.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static void settimeout(unsigned short timeout)

{
	pubdisptimeout timeoutinfo ;


	(timeoutinfo . commandHeader . commandCode) = F_PUBSRVCDISPTIMEOUT ;
	(timeoutinfo . timeOut) = timeout ;
	if(pubservicecall(&timeoutinfo) < 0)
	{
		fprintf(stderr, "\n\aCan't set display timeout.\n") ;

		exit(1) ;
	}
}

/*---------------------------------------------------------------------------*/

/* Function: adjuststuff
   Purpose: Make some display adjustments.
   Used by: Anyone.
   Returns: Nothing.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

static void adjuststuff(void)

{
	unsigned long timeout ;

	unsigned short tensity, newtensity ;


	/* Display current backlight settings.
	*/
	tensity = getintensity() ;
	timeout = (unsigned long)gettimeout() ;
	printf("\nCurrent intensity: %hu", tensity) ;
	printf("\nCurrent timeout:   %lu ticks(s)\n", timeout) ;

	/* Adjust display-related settings.
	*/
	newtensity = (tensity / 3) ;

	if((timeout += (1092 + 1)) > USHRT_MAX)
	{
		timeout = USHRT_MAX ;
	}
	settimeout((unsigned short)timeout) ;
	printf("\nTimeout set to %lu tick(s).", timeout) ;

	printf("\nSetting intensity to %hu...", newtensity) ;
	settensity(newtensity) ; /* Change the backlight intensity. */
	delay(4000) ;
	printf("\nRestoring intensity to %hu...", tensity) ;
	settensity(tensity) ; /* Restore the backlight intensity. */
	delay(4000) ;
}

/*---------------------------------------------------------------------------*/

/* Function: main
   Purpose: Program entry point.
   Used by: Program launcher.
   Returns: Never.
   Notes:
   Revision history:
     1) Wednesday December 10, 1997 -- 12:50:47.
*/

int main(unsigned argc, char *argv[])

{
	checkcpu() ;
	publicapicheck() ;

	adjuststuff() ;

	printf("\n\nThat's all, folks.\n") ;

	exit(0) ;
}

/*---------------------------------------------------------------------------*/
