const

ROMBIOSIDSEG = $F000         ; { Segment of ROMBIOS I.D. structure. }
ROMBIOSIDOFF = $FF00         ; { Offset of ROMBIOS I.D. structure in segment ROMBIOSIDSEG. }

BIOSIDMSG = 'MESAFPTX'         ; { ROMBIOS identifier message. }

IDSTRUCTREV = 0         ; { Version number of the ROMBIOSID structure. }

{-------------------------------------------------------------------------}

{ Structures.
}

{ ROMBIOS I.D. structure.  The ROMBIOS contains a structure of this type at
	 location ROMBIOSIDSEG:ROMBIOSIDOFF.
}
type rombiosid =
record
	sysMsg : array [1..17] of char; { System I.D. message for utilities. }

	hdrVers  : byte;       { Header version. }

	rbRevMS  : byte;       { ROMBIOS version number high : byte. }
	rbRevLS  : byte;       { ROMBIOS version number low : byte. }
	rbRevSfx : byte;       { ROMBIOS version number suffix. }

	biosLength : longint;  { Number of : bytes of BIOS object code. }
	biosROMLengthK : byte; { Size of BIOS ROM in K: bytes. }

	hZ : longint;          { CPU clock frequency in cycles per second. (If implemented by ROMBIOS.) }

	baudList : array [1..16] of word; { Baud rate divisor table for CPUs with non-standard clock frequencies. }

	userIntNum : byte          ; { User NMI interrupt vector number. (If implemented by ROMBIOS.) }

	tickPrescale : byte           ; { System tick prescale value. (If implemented by ROMBIOS.) }

	rbBlurb : array [1..83] of char            ; { OEM blurb area. }
	rbNotice: array [1..83] of char           ; { Copyright notice area. }

	jmp2Services : array [0..2] of byte           ;       { Near jump to CPU-specific private services handler entry point. }
	jmp2PublicServices: array [0..2] of byte           ; { Near jump to CPU-specific public services handler entry point. }
end; { rombiosid }
