/*---------------------------------------------------------------------------*/
/*
   "BIOSID.H"

   Include file defining the ROMBIOS I.D. structure.

   Version 1.0, Tuesday December 10, 1996 -- 17:46:23.

   Copyright (c) 1996 by Mesa Electronics.
*/
/*---------------------------------------------------------------------------*/
/*
   Revision history.

   1) Version 1.0, Tuesday December 10, 1996 -- 17:46:23.

	  Code frozen for version 1.0.
*/
/*---------------------------------------------------------------------------*/

#if !defined H_BIOSID
#define H_BIOSID

/*---------------------------------------------------------------------------*/

/* #defines.
*/
#define ROMBIOSIDSEG 0xF000 /* Segment of ROMBIOS I.D. structure. */
#define ROMBIOSIDOFF 0xFF00 /* Offset of ROMBIOS I.D. structure in segment ROMBIOSIDSEG. */

#define BIOSIDMSG "MESAFPTX" /* ROMBIOS identifier message. */

#define IDSTRUCTREV 0 /* Version number of the ROMBIOSID structure. */

/*---------------------------------------------------------------------------*/

/* Structures.
*/

/* ROMBIOS I.D. structure.  The ROMBIOS contains a structure of this type at
	 location ROMBIOSIDSEG:ROMBIOSIDOFF.
*/
typedef struct rombiosid
{	char sysMsg[16 + 1] ; /* System I.D. message for utilities. */

	unsigned char hdrVers ; /* Header version. */

	unsigned char rbRevMS ;  /* ROMBIOS version number high byte. */
	unsigned char rbRevLS ;  /* ROMBIOS version number low byte. */
	unsigned char rbRevSfx ; /* ROMBIOS version number suffix. */

	unsigned long biosLength ;     /* Number of bytes of BIOS object code. */
	unsigned char biosROMLengthK ; /* Size of BIOS ROM in Kbytes. */

	unsigned long hZ ; /* CPU clock frequency in cycles per second. (If implemented by ROMBIOS.) */

	unsigned short baudList[16] ; /* Baud rate divisor table for CPUs with non-standard clock frequencies. */

	unsigned char userIntNum ; /* User NMI interrupt vector number. (If implemented by ROMBIOS.) */

	unsigned char tickPrescale ; /* System tick prescale value. (If implemented by ROMBIOS.) */

	char rbBlurb[82 + 1]  ; /* OEM blurb area. */
	char rbNotice[82 + 1] ; /* Copyright notice area. */

	unsigned char jmp2Services[3] ;       /* Near jump to CPU-specific private services handler entry point. */
	unsigned char jmp2PublicServices[3] ; /* Near jump to CPU-specific public services handler entry point. */
} rombiosid ;

/*---------------------------------------------------------------------------*/

#endif
