;************************************************************************
;*
;************************************************************************
		comment	`

"MFGCODES.INC"

POST codes for Mesa CPUs.

Version 1.0, Thursday January 27, 1994 - 12:46:16.

Copyright (c) 1994 by Mesa Electronics.

			`
;************************************************************************
;*
;*	Revision history.
;*
;************************************************************************
		comment	`

1) Version 1.0 - Thursday January 27, 1994 - 12:46:16.

   Code frozen for first version.

		`
;************************************************************************
;*
;*	Assembler: Masm, version 6.1.
;*
;************************************************************************
		ifndef	INC_MFGCODES
INC_MFGCODES	=	1

;************************************************************************
;*
;*	Equates.
;*
;************************************************************************
;
;	Standard POST codes.
;
POST_START	equ	001H			;Entry from hardware reset vector.
POST_HDRWSETUP	equ	008H			;Begin CPU-specific hardware initialization.
POST_ROMCHKSUM	equ	010H			;Begin ROM checksum.
POST_RAM	equ	018H			;Begin RAM initialization.
POST_RIPLCHK1	equ	020H			;Check for remote IPL, point 1.
POST_RIPL1	equ	021H			;Begin remote IPL, point 1.
POST_CONFIG	equ	028H			;Begin configuration determination.
POST_ALIVE	equ	030H			;Hardware interrupts enabled.
POST_BEDCHECK	equ	038H			;Begin search for ROM-resident add-ons.
POST_VIDEO	equ	040H			;Begin video setup.
POST_VGAINIT	equ	041H			;Call to VGA ROM initialization code.
POST_VGADUN	equ	042H			;Return from call to VGA ROM initialization code.
POST_FLOPPY	equ	048H			;Begin floppy disk initialization.
POST_HARD	equ	050H			;Begin hard disk initialization.
POST_LPTPORTS	equ	058H			;Begin LPT port search/initialization.
POST_COMPORTS	equ	05CH			;Begin COM port search/initialization.
POST_ROMSCAN	equ	060H			;Begin search for ROMBIOS extension ROMs.
POST_ROMSCANDUN	equ	061H			;End search for ROMBIOS extension ROMs.
POST_RAMD	equ	068H			;Begin local RAMdisk code initialization.
POST_ROMDOS	equ	070H			;Begin ROM-DOS initialization.
POST_RIPLCHK2	equ	078H			;Check for remote IPL, point 2.
POST_RIPL2	equ	079H    		;Begin remote IPL, point 2.
POST_LAUNCH	equ	000H			;Invoke interrupt 019H.

;
;	Warning codes.
;
POSTWARN_BADROMCSUM	equ	0E0H		;Invalid BIOS extension ROM checksum.
POSTWARN_ROMINITFAIL	equ	0E1H		;BIOS extension ROM initialization failure.
POSTWARN_VGAINITFAIL	equ	0E2H		;VGA ROM initialization failure.
POSTWARN_BADCONFIG	equ	0E3H		;Invalid system configuration.
POSTWARN_BOOTFAIL	equ	0E4H		;Can't launch system.

;
;	Fatal error codes.  (Cause the CPU to stop.)
;
POSTERR_ROMCSUM		equ	0F0H		;Bad ROM checksum.
POSTERR_MEMBAD		equ	0F1H		;Memory is broken.
POSTERR_NOTNUFFMEM	equ	0F2H		;Not enough working system memory to start.

;************************************************************************
;*
;************************************************************************
		endif
