program SC;  { set contrast on FPCX with Samtron UG display}
uses dos,crt;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}
type
AdjFuncs = (ADJCont,ADJBright,ADJTime);

{$I WIDGET}
{ include our pictures }
const
{ include the button pictures }
{$I FPCXSBUTS}

ContrastStep = $60;
MaxContrast = $FFFF;
MinContrast = $D000;

BrightnessStep = $800;
MaxBrightness = $FFFF;
MinBrightness = $1000;

TimeoutStep = 1;
MaxTimeOut = 60;
MinTimeout = 1;

KeySave = #$68;
KeyExit = #$69;
KeyFunc  = #$6A;
KeyUp   = #$6B;
KeyDown = #$6C;

var
FullScreen,TextRegion,ButRegion : RectRec;
TextWindow : TextWindowPtr;
ControlInfo : FuncHdrRec;
AdjFunc : AdjFuncs;

OldContrast : word;
Contrast : word;
OldTimeOut : byte;
TimeOut : byte;
OldBrightness : word;
Brightness : word;
Saved : boolean;

procedure BltButs;
begin
  GetDispRect(FullScreen);
  SplitRectY(FullScreen,TextRegion,ButRegion,RectYSize(FullScreen)-FPCXDbutYDim);
  BLT(@FPCXDbut,FPCXDbutXdim,FPCXDButYDim,0,ButRegion.UL.Y,RasterOp_NRep,BothPlanes);
end;

procedure FuncUP;
begin
  case AdJFunc of
    AdjCont:
    begin
      AdjFunc := AdjBright;
      GotoXY(5,1);
      write(chr(13),'Adjusting Brightness       ');
    end;
    AdjBright:
    begin
      AdjFunc := AdjTime;
      GotoXY(5,1);
      write(chr(13),'Adjusting Timeout (Minutes)');
    end;
    AdjTime:
    begin
      AdjFunc := AdjCont;
      GotoXY(5,1);
      write(chr(13),'Adjusting Contrast         ');
    end;
  end;
end;

procedure ShowStartVals;
begin
  GotoXY(1,3);
  write(chr(13),'  Contrast = ',Contrast,'  ');
  GotoXY(1,5);
  write(chr(13),'  Brightness = ',Brightness,'  ');
  GotoXY(1,7);
  write(chr(13),'  Timeout = ',TimeOut,'  ');
end;

procedure ContrastUp;
begin
  if Contrast < (MaxContrast-ContrastStep) then Contrast := Contrast + ContrastStep;
  SetContrast(Contrast);
  GotoXY(1,3);
  write(chr(13),'  Contrast = ',Contrast,'  ');
end;

procedure ContrastDown;
begin
  if Contrast > MinContrast+ContrastStep then Contrast := Contrast - ContrastStep;
  SetContrast(Contrast);
  GotoXY(1,3);
  write(chr(13),'  Contrast = ',Contrast,'  ');
end;

procedure BrightnessUp;
begin
  if Brightness < (MaxBrightness-BrightnessStep) then Brightness := Brightness + BrightnessStep;
  SetBrightness(Brightness);
  GotoXY(1,5);
  write(chr(13),'  Brightness = ',Brightness,'  ');
end;

procedure BrightnessDown;
begin
  if Brightness > MinBrightness+BrightnessStep then Brightness := Brightness - BrightnessStep;
  SetBrightness(Brightness);
  GotoXY(1,5);
  write(chr(13),'  Brightness = ',Brightness,'  ');
end;

procedure TimeOutUp;
begin
  if TimeOut < (MaxTimeOut-TimeOutStep) then TimeOut := TimeOut + TimeOutStep;
  SetDispTimeOut(TimeOut);
  GotoXY(1,7);
  write(chr(13),'  Timeout = ',TimeOut,'  ');
end;

procedure TimeOutDown;
begin
  if TimeOut > MinTimeOut+TimeOutStep then TimeOut := TimeOut - TimeOutStep;
  SetDispTimeOut(TimeOut);
  GotoXY(1,7);
  write(chr(13),'  TimeOut = ',TimeOut,'  ');
end;

procedure KeyLoop;
var
done : boolean;
begin
  TextWindow := TTYWinCreate(TextRegion,false,1);
  ShowStartVals;
  Saved := false;
  done := false;
  AdjFunc := AdjTime;
  FuncUp;
  while not done do
  begin
    while readkey <> #0 do { wait for special char };
    case readkey of
      KeySave :
      begin
        SaveSetup;
        GotoXY(1,9);
        write(chr(13),'  Saved!','      ');
        Delay(500);
        GotoXY(1,9);
        write(chr(13),'                 ');
        Saved := true;
      end;
      KeyExit :
      begin
        done := true;
      end;
      KeyFunc :
      begin
        FuncUp;
      end;
      KeyUp   :
      begin
        case AdjFunc of
          AdjCont : ContrastUp;
          AdjBright : BrightnessUp;
          AdjTime : TimeOutUp;
        end;
      end;
      KeyDown :
      begin
        case AdjFunc of
          AdjCont : ContrastDown;
          AdjBright : BrightnessDown;
          AdjTime : TimeOutDown;
        end;
      end;
    end;
  end;
end;

procedure SaveOldVals;
begin
  OldContrast := GetContrast;
  Contrast := OldContrast;
  OldBrightness := GetBrightness;
  Brightness := OldBrightness;
  OldTimeout := GetDispTimeout;
  Timeout := OldTimeout;
end;

procedure RestoreOldVals;
begin
  SetContrast(OldContrast);
  SetBrightness(OldBrightness);
  SetDispTimeout(OldTimeout);
  SaveSetup ;
  GotoXY(1,9);
  write(chr(13),'Restoring old values!');
  Delay(500);
end;

begin          {main}
  InitGraphics;
  DirectVideo := false;
  BltButs;
  KeyPadOnly;
  SaveOldVals;
  KeyLoop;
  if not Saved then RestoreOldVals;
  ExitGraphics;
end.
