program SC;  { set contrast on FPCX with Samtron UG display}
uses dos,crt;

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

{$I WIDGET}
{ include our pictures }
const
{ include the button pictures }
{$I FPCXDBUTS}

ContrastStep = $60;
MaxContrast = $FFFF;
MinContrast = $D000;

KeySave = #$68;
KeyExit = #$69;
KeyOld  = #$6A;
KeyUp   = #$6B;
KeyDown = #$6C;

var
FullScreen,TextRegion,ButRegion : RectRec;
TextWindow : TextWindowPtr;
ControlInfo : FuncHdrRec;


OldContrast : word;
Contrast : word;
OldTimeOut : byte;
TimeOut : byte;
OldBrightness : word;
Brightness : word;

procedure BltButs;
begin
  GetDispRect(FullScreen);
  SplitRectY(FullScreen,TextRegion,ButRegion,RectYSize(FullScreen)-FPCXDbutYDim);
  BLT(@FPCXDbut,FPCXDbutXdim,FPCXDButYDim,0,ButRegion.UL.Y,RasterOp_NRep,BothPlanes);
end;

procedure KeyLoop;
var
done : boolean;
popup : boolean;
begin
  done := false;
  popup := false;
  while not done do
  begin
    while readkey <> #0 do { wait for special char };
    case readkey of
      KeySave :
      begin
        SaveSetup ;
        if not popup then TextWindow :=TTYWinCreate(TextRegion,false,1);
        write(chr(13),'  Saved!','      ');
        popup := true;
      end;
      KeyExit :
      begin
        done := true;
      end;
      KeyOld :
      begin
        Contrast := OldContrast;
        SetContrast(Contrast);
        if not popup then TextWindow := TTYWinCreate(TextRegion,false,1);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
      KeyUp   :
      begin
        if Contrast < (MaxContrast-ContrastStep) then Contrast := Contrast + ContrastStep;
        SetContrast(Contrast);
        if not popup then TextWindow := TTYWinCreate(TextRegion,false,1);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
      KeyDown :
      begin
        if Contrast > MinContrast then Contrast := Contrast - ContrastStep;
        SetContrast(Contrast);
        if not popup then TextWindow := TTYWinCreate(TextRegion,false,1);
        write(chr(13),'  Cont = ',Contrast,'  ');
        popup := true;
      end;
    end;
  end;
end;

begin          {main}
  InitGraphics;
  DirectVideo := false;
  OldContrast := GetContrast;
  Contrast := OldContrast;
  BltButs;
  KeyPadOnly;
  KeyLoop;
  ExitGraphics;
end.
