program NEWPCX;  { print monochrome PCX files on 4C22, FPWX, etc }
uses dos;
{ crt unit removed do to unavoidable clear screen (set vmode) on entry }

{$R-}    {Range checking be off }
{$I-}    {No I/O checking }
{$S-}    {No stack checking}

const
{$I SInt10.pas}

FileBufferSize = $1000;      { 4K, enough for most small screen stuff in one snort }
LineBufferSize = $80;        { for up to 1k bits wide! }
Int16ChecKB    = $11;
ZeroFlagMask  : word = $0040;

{$I PCXHDR}

type

FileBufferType = array[0..FileBufferSize -1] of byte;
LineBufferType = array[0..LineBufferSize -1] of byte;

PtrRec = record
  Ofs : word;
  Smt : word;
end;

GrFuncHdrType = record
  CommandCode : byte;
  ErrorCode : byte;
end;

PointType = record
  X : word;
  Y : word;
end;

RectType = record
  UL : PointType;
  LR : PointType;
end;

BltRecord = record
  GrFuncHdr : GrFuncHdrType;
  SourceRect : RectType;
  SourcePitch : word;
  SourcePtr : pointer;
  DestPoint : PointType;
  DestPitch : word;
  DestPtr : pointer;
  RasterOp : byte;
  PlaneMask : byte;
end;

MiscRecord = record
  GrFuncHdr : GrFuncHdrType;
  Parms : array[1..16] of byte;
end;

var
BlinkOn : boolean;
ReverseOn : boolean;
ShowHeaderOn : boolean;
Plane1Only : boolean;
Plane2Only : boolean;
WaitForUser : boolean;
BltInfo : BltRecord;
FileBuffer : FileBufferType;
LineBuffer : LineBufferType;
BitFileName : string[80];
BitFile : file;
PCXBytesPerLine : word;
PCXLines : word;
PCXCols : word;
PCXLastByteMask : byte;
TinyCurByte : word;
PCXCurByte : word;
NextCount : byte;
PCXHeader : PCXHeaderType;
LineCount : word;
LookForRepeatCount : boolean;
DoneDrawing : boolean;
XOffset : byte;
YOffset : byte;
CPURegs : registers;
MiscFuncs : MiscRecord;
type

PCXHeaderArray = array[0..sizeof(PCXHeader)] of byte;

procedure DisableInterrupts; inline($FA);      { CLI }

procedure EnableInterrupts;  inline($FB);      { STI }

procedure MesaGrFunc(p: pointer);
begin
  asm
    mov ah,F_SPCLVIDGRFX
    mov cx,PtrRec[p].Smt
    mov bx,PtrRec[p].Ofs
    int 10h
  end;
end;

procedure PrintUsage;
begin
  writeln;
  writeln('USAGE -> $ FILE X Y [-BRSW12]');
  writeln('FUNCT -> PCX > 4C22 or FPWX LCD display');
  writeln;
  writeln('FILE = Monochrome PCX file');
  writeln('X is the X OFFSET');
  writeln('Y is the Y OFFSET');
  writeln('B enables blink, R inverts video,');
  writeln('S Shows PCX header data');
  writeln('W enables wait on return press to exit');
  writeln('1 enables writing to plane 1 only');
  writeln('2 enables writing to plane 2 only');
  halt(2);
end;

function UpString(s:string) : string;
var
index : byte;
begin
  for index := 1 to length(s) do
  s[index] := upcase(s[index]);
  UpString := s;
end;

function OpenForRead(name: string): boolean;
begin
  Assign(BitFile,name);
  {$I-}
  Reset(BitFile,1);
  {$I+}
  OpenForRead := (IOResult = 0);
end { OpenForRead };

procedure Barfout(s: string);
begin
  writeln(s);
  halt(2);
end;

procedure NoFileBumout;
begin
  writeln('File ',BitFileName,' not found');
  halt(2);
end;

procedure SetupBLTRec;
begin
  with BLTInfo do
  begin
    GrFuncHdr.CommandCode :=F_GRFXBITBLT;
    { setup for 1 scanline a a time }
    SourceRect.UL.X := 0;
    SourceRect.UL.Y := 0;
    SourceRect.LR.X := PCXCols;
    SourceRect.LR.Y := 0;
    SourcePitch := PCXBytesPerLine;
    SourcePtr := @LineBuffer;
    if ReverseOn then RasterOp := RASTEROP_REP else RasterOp :=RASTEROP_NREP;
    if BlinkOn then RasterOp := RasterOp or F_BLINKON;
    PlaneMask := $03;          { both if not specified }
    if Plane1Only then PlaneMask := $01;
    If Plane2Only then PlaneMask := $02;
  end;
end;

procedure GetParms;
var
retcode : word;
pstring : string;
begin
  if length(ParamStr(1)) < 1 then PrintUsage;
  BitFileName := ParamStr(1);
  If not OpenForRead(BitFileName) then NoFileBumout;
  if length(paramStr(2)) >= 1 then
  begin
    val(ParamStr(2),XOffset,retcode);
    if retcode <> 0 then BarfOut('Bad X offset');
  end;
  if length(paramStr(3)) >= 1 then
  begin
    val(ParamStr(3),YOffset,retcode);
    if retcode <> 0 then BarfOut('Bad Y offset');
  end;
  if length(paramStr(4)) >= 1 then
  begin
    if pos('-',ParamStr(4)) <> 0 then
    begin
      pstring := UpString(ParamStr(4)+ParamStr(5)+ParamStr(6)+ParamStr(7));
      if pos('B',pstring) <> 0 then BlinkOn := true;
      if pos('R',pstring) <> 0 then ReverseOn := true;
      if pos('S',pstring) <> 0 then ShowHeaderOn := true;
      if pos('1',pstring) <> 0 then Plane1Only := true;
      if pos('2',pstring) <> 0 then Plane2Only := true;
      if pos('W',pstring) <> 0 then WaitForUser := true;
    end;
  end;
end;

procedure InitVars;
begin
  BlinkOn := false;
  ReverseOn := false;
  WaitForUser := false;
  Plane1Only := false;
  Plane2Only := false;
  XOffset := 0;
  YOffset := 0;
  PCXCurByte := 0;
  LineCount := 0;
  LookForRepeatCount := true;
  DoneDrawing := false;
  GetParms;
end;

function FillBuffer : word;
var
readcount : word;
begin
  blockread(BitFile,FileBuffer,FileBufferSize,readcount);
  FillBuffer := readcount;
end;

procedure ShowHeader;
begin
  writeln('PCX Version = ',PCXHeader.Version);
  writeln('image size = ',PCXCols,' by ',PCXLines);
  writeln('image resolution = ',PCXHeader.HRes,' by ',PCXHeader.VRes);
  writeln('image has ',PCXHeader.NPlanes,' planes');
  writeln(' with ',PCXHeader.BitsPerPlane,' bits per plane');
  writeln(' press return to return to DOS');
end;

procedure KeyWait;
var foo : string;
begin
  readln(foo);
  {while not keypressed do {nothing}
end;

procedure ProcessHeader;
begin
  PCXBytesPerLine := PCXHeader.BytesPerLine;
  PCXLines := PCXHeader.Y2-PCXHeader.Y1 +1;
  PCXCols  := PCXHeader.X2-PCXHeader.X1 +1;
  PCXLastByteMask := $FF shr (8-(PCXCols mod 8));
  If ShowHeaderOn then ShowHeader;
  if PCXHeader.Nplanes <> 1 then
  begin
    if PCXHeader.Nplanes <> 4 then
    begin
      BarfOut('This program only works on monochrome or 16 color PCX files');
    end;
  end;
  if PCXHeader.BitsPerplane <> 1 then BarfOut('This program only works on monochrome or 16 color PCX files');
end;

procedure SleepCursor;
begin
  MiscFuncs.GrFuncHdr.CommandCode :=F_GRFXCRSRXABL;
  MiscFuncs.Parms[1] := $00;
  MesaGrFunc(@MiscFuncs);
end;

procedure WakeCursor;
begin
  MiscFuncs.GrFuncHdr.CommandCode :=F_GRFXCRSRXABL;
  MiscFuncs.Parms[1] := $FF;
  MesaGrFunc(@MiscFuncs);
end;

{procedure ClearScreen;
var
int10regs : registers;

begin
  int10regs.ah := Int10SetVidMode;
  int10regs.al := 0;
  intr($10,int10regs)
end;
}

procedure LineBufPrint(x,y : byte);
begin
  BLTInfo.DestPoint.X := x;
  BLTInfo.DestPoint.Y := y+ LineCount;
  MesaGrFunc(@BLTInfo);
end;

procedure LineBufPut(pbyte : byte;pcount : byte);
var
count : byte;
begin
  count := pcount;
  while count >0 do
  begin
    LineBuffer[PCXCurByte] := pbyte;
    PCXCurByte := PCXCurByte +1;
    count := count-1;
    if PCXCurByte = PCXBytesPerLine then
    begin
      { fix last byte }
      Linebuffer[PCXBytesPerLine-1] := LineBuffer[PCXBytesPerLine-1] or PCXLastByteMask;
      LineBufPrint(XOffset,YOffset);
      LineCount := LineCount + 1;
      if LineCount = PCXLines then DoneDrawing := true;
      PCXCurByte := 0;
    end;
  end;
end;

procedure ExpandToLine(combyte : byte);
begin
  if LookForRepeatCount then
  begin
    NextCount := 1;
    if (combyte and CountToken) = CountToken then
    begin
      NextCount := combyte and CountMask;
      LookForRepeatCount := false;
    end
    else LineBufPut(combyte,1);
  end
  else
  begin
    LineBufPut(combyte,NextCount);
    LookForRepeatCount := true;
  end;
end;

procedure DrawData;
var
combyte : byte;
count : word;
del : word;
firstbucket : boolean;
firstbucsize : word;
pcxptr : ^ PCXHeaderArray;
begin
  firstbucket := true;
  pcxptr := @PCXHeader;
  while (not EOF(BitFile)) and (not DoneDrawing) do
  begin
    if firstbucket then
    begin
      firstbucsize := FillBuffer;
      if firstbucsize <= sizeof(PCXHeader) then BarfOut(BitFileName+' is not a PCX file');
      for count := 1 to sizeof(PCXHeader) do   { read in header first }
      begin
        pcxptr^[count-1] := FileBuffer[count-1];
      end;
      ProcessHeader;
      SleepCursor;
      SetupBLTRec;
      for count := (sizeof(PCXHeader)+1) to firstbucsize do
      begin
        combyte := FileBuffer[count-1];
        if not DoneDrawing then ExpandToLine(ComByte);
      end;
      firstbucket := false;
    end; { if firstbucket }
    for count := 1 to FillBuffer do
    begin
      combyte := FileBuffer[count-1];
      if not DoneDrawing then ExpandToLine(ComByte);
    end;
  end;
end;

begin          {main}
  InitVars;
  DrawData;
  if WaitForUser then Keywait;
  WakeCursor;
end.
